/*
 * getrecord.c
 *
 * Get a single record from a file.
 * Returns NULL on EOF, or for comment/blank lines.
 *
 * Copyright (c) 2000, 2002 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 */
#include <stdio.h>
#include "getrecord.h"

char *getrecord(FILE *fptr) {
  static char record[1025];
  char str[1025];
  int i;

  fgets(record, 1025, fptr);
  if(feof(fptr)) {
    return(NULL);
    }
  i = sscanf(record, "%1024s", str); /* strip leading whitespace */

  if(i == EOF) {
    return(NULL); /* empty line/EOF */
    }
  if(str[0] == '#') {
    return(NULL); /* comment */
    }
  return(record);
}
