#!/usr/bin/python
# mkpositions.py
#
# This file is part of Automaton.
#
# Copyright (C) 2002, 2003
# Paul Gettings, Dep't of Geology & Geophysics
# University of Utah
#
# This file is released under the terms of the software
# license in the file "LICENSE" in the root directory of
# this package.  If this file is missing or corrupt, please
# contact the author to receive a new copy.
#
# Automaton is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  Use at your
# own risk; your mileage may vary.
#
# Suggestions, improvements, and bug reports welcome at
# <gettings@mines.utah.edu>
#

#
# Create a position file for insertion into a SEGY file
#
# This code generates a set of positions for 120 channels, with
# channel 1 at offset 0, and each channel 0.5m downline from the
# previous one.  All have Y positions of 0.
#
# The outer loop is the number of shots, here set to 48.
#
# Note the print statement, which uses C syntax for formatting,
# and the order of fields is:
# shot #    channel #   x  y
#

def main():
  print "# position file for 48 shots, 120 chan per shot"
  print "# 0.5m channel spacing"
  for i in range(48):
    for j in range(120):
      print "%5d %5d %20.3f %20.3f"%(i+1, j+1, j*0.5, 0)

main()
