#include <stdio.h>
#include <stdlib.h>
#include "autopick.h"
#include "segy.h"

int main(int argc, char *argv[])
{
  seismicData S;
  seismicData *mS;
  long i, j, k, ns, shot;
  unsigned short dt;
  char name[20];
  FILE *fp;

  bool swapBytes = true, reelHeader = false;

  fprintf(stderr, "main: start\n");
  fp = fopen(argv[1], "r");
  if(fp == NULL) {
    printf("blurp.\n");
    exit(1);
    }
  fprintf(stderr, "main: file opened, start read\n");

  shot = checkSEGY(fp, swapBytes, reelHeader, &i, &j);
  if(!shot) {
    fprintf(stderr, "main: checkSEGY returned error code\n");
    exit(1);
    }
  if(j > 1) {
    ns = j;
    printf("multiple shots in SEGY file\n");
    mS = readSEGYMultiShot(fp, j, swapBytes, reelHeader);
    if(mS == NULL) {
      fprintf(stderr, "main: readSEGYMultiShot returned error code.\n");
      exit(1);
      }
    printf("_Shot_ __nt__ ns_tr1\n");
    for(i=0; i<ns; i++) {
      printf("%6d %6d %6d\n", mS[i].shot, mS[i].n, mS[i].data[0].n);
      }
    // create individual shot files
    for(i=0; i<ns; i++) {
      fclose(fp);
      sprintf(name, "/tmp/shot%03d", mS[i].shot);
      fp = fopen(name, "wb");
      fprintf(fp, "shot from multi-shot segy file '%s'\n", argv[1]);
      fprintf(fp, "%d\n", mS[i].shot);
      for(j=0; j<mS[i].n; j++) {
        fprintf(fp, "G %d %f %f %d\n", mS[i].num[j], mS[i].x[j], mS[i].y[j], mS[i].data[j].n);
        for(k=0; k<mS[i].data[j].n; k++) {
          fprintf(fp, "  %20g %20g\n", mS[i].data[j].time[k], mS[i].data[j].amp[k]);
          }
	}
      }
    }
  else {
    printf("single shot SEGY file\n");
    i = readSEGYSingleShot(fp, i, &S, swapBytes, reelHeader);
    printf("return val:%d shot #:%d nTraces:%d nSamples(trace 1):%d\n", i, S.shot, S.n, S.data[0].n);
    fclose(fp);
    }
  fclose(fp);
}
